/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("49d951a4-ca9c-48b5-b549-61ef67ee53aa"), "NetheriteBackpackBonusArmor", 4.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("294425c4-8dc6-4640-a336-d9fd72950e20"), "DiamondBackpackBonusArmor", 3.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("fcf6706b-dfd9-40d6-aa25-62c4fb7a83fa"), "IronBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("21060f97-da7a-4460-a4e4-c94fae72ab00"), "GoldBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    private static final EntityPredicate OCELOT_ABILITY_PREDICATE = new EntityPredicate().func_221013_a(6.0);
    public static final Item[] ALL_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_REMOVAL_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_ABILITIES_LIST = new Item[]{(Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get()};

    public void abilityTick(@Nullable ItemStack stack, @Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        if (tile == null) {
            if (stack.func_77973_b() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, false, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, false, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, false, this.GOLD_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(player, null);
            }
            if (stack.func_77973_b() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, false, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(player, null);
            }
            if (stack.func_77973_b() == ModItems.DRAGON_TRAVELERS_BACKPACK.get()) {
                this.dragonAbility(player);
            }
            if (stack.func_77973_b() == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
            }
            if (stack.func_77973_b() == ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()) {
                this.magmaCubeAbility(player);
            }
            if (stack.func_77973_b() == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                this.witherAbility(player);
            }
            if (stack.func_77973_b() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                this.batAbility(player);
            }
            if (stack.func_77973_b() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
            }
            if (stack.func_77973_b() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(player, false);
            }
            if (stack.func_77973_b() == ModItems.SQUID_TRAVELERS_BACKPACK.get()) {
                this.squidAbility(player);
            }
        } else {
            Item item = tile.getItemStack().func_77973_b();
            if (item == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(null, tile);
            }
        }
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        if (tile == null) {
            if (stack.func_77973_b() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, true, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, true, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, true, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.armorAbility(player, null, true, this.GOLD_ARMOR_MODIFIER);
            }
        }
    }

    public void animateTick(@Nullable TravelersBackpackTileEntity tile, BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (tile != null && tile.getAbilityValue()) {
            Block block = stateIn.func_177230_c();
            if (block == ModBlocks.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(null, tile);
            }
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, tile);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(null, tile);
            }
        }
    }

    public void emeraldAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        World world;
        World world2 = world = player == null ? tile.func_145831_w() : player.field_70170_p;
        if (player == null || world.field_73012_v.nextInt(10) == 1) {
            float f = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = world.field_73012_v.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, player == null ? (double)((float)tile.func_174877_v().func_177958_n() + f2 + 0.5f) : player.func_213303_ch().field_72450_a + (double)f2, player == null ? (double)((float)tile.func_174877_v().func_177956_o() + world.field_73012_v.nextFloat()) : player.func_174813_aQ().field_72338_b + (double)world.field_73012_v.nextFloat() + 0.5, player == null ? (double)((float)tile.func_174877_v().func_177952_p() + f3 + 0.5f) : player.func_213303_ch().field_72449_c + (double)f3, (double)((float)Math.pow(2.0, (double)(world.field_73012_v.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void armorAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile, boolean isRemoval, AttributeModifier modifier) {
        ModifiableAttributeInstance armor = player.func_110148_a(Attributes.field_233826_i_);
        if (isRemoval && armor != null && armor.func_180374_a(modifier)) {
            armor.func_233770_c_(modifier.func_111167_a());
        }
        if (!isRemoval && armor != null && !armor.func_180374_a(modifier)) {
            armor.func_233769_c_(modifier);
        }
    }

    public void armorAbilityRemovals(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        this.armorAbility(player, tile, true, this.NETHERITE_ARMOR_MODIFIER);
        this.armorAbility(player, tile, true, this.DIAMOND_ARMOR_MODIFIER);
        this.armorAbility(player, tile, true, this.IRON_ARMOR_MODIFIER);
        this.armorAbility(player, tile, true, this.GOLD_ARMOR_MODIFIER);
    }

    public void bookshelfAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        BlockPos enchanting = BackpackUtils.findBlock3D(tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), Blocks.field_150381_bn, 2, 2);
        if (enchanting != null) {
            if (!tile.func_145831_w().func_175623_d(new BlockPos((enchanting.func_177958_n() - tile.func_174877_v().func_177958_n()) / 2 + tile.func_174877_v().func_177958_n(), enchanting.func_177956_o(), (enchanting.func_177952_p() - tile.func_174877_v().func_177952_p()) / 2 + tile.func_174877_v().func_177952_p()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                tile.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)enchanting.func_177958_n() + 0.5, (double)enchanting.func_177956_o() + 2.0, (double)enchanting.func_177952_p() + 0.5, (double)((float)(tile.func_174877_v().func_177958_n() - enchanting.func_177958_n()) + tile.func_145831_w().field_73012_v.nextFloat()) - 0.5, (double)((float)(tile.func_174877_v().func_177956_o() - enchanting.func_177956_o()) - tile.func_145831_w().field_73012_v.nextFloat() - 1.0f), (double)((float)(tile.func_174877_v().func_177952_p() - enchanting.func_177952_p()) + tile.func_145831_w().field_73012_v.nextFloat()) - 0.5);
            }
        }
    }

    public void spongeAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        if (!tile.getLeftTank().isEmpty() && !tile.getRightTank().isEmpty() && tile.getLeftTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getRightTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getLeftTank().getFluidAmount() == tile.getLeftTank().getCapacity() && tile.getRightTank().getFluidAmount() == tile.getRightTank().getCapacity()) {
            float f = tile.func_145831_w().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = tile.func_145831_w().field_73012_v.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
            tile.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)((float)tile.func_174877_v().func_177958_n() + f2 + 0.5f), (double)((float)tile.func_174877_v().func_177956_o() + tile.func_145831_w().field_73012_v.nextFloat()), (double)((float)tile.func_174877_v().func_177952_p() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(tile.func_145831_w().field_73012_v.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void chickenAbility(@Nullable PlayerEntity player, boolean firstSwitch) {
        TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
        if (firstSwitch && inv.getLastTime() <= 0 && !inv.getLevel().field_72995_K) {
            inv.setLastTime((200 + 10 * player.field_70170_p.field_73012_v.nextInt(10)) * 20);
            inv.setDataChanged(6);
        }
        if (inv.getLastTime() <= 0) {
            player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.AMBIENT, 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.3f + 1.0f);
            player.func_199703_a((IItemProvider)Items.field_151110_aK);
            if (!inv.getLevel().field_72995_K) {
                inv.setLastTime((200 + 10 * player.field_70170_p.field_73012_v.nextInt(10)) * 20);
                inv.setDataChanged(6);
            }
        }
    }

    public void cactusAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        ITravelersBackpackInventory inv = player == null ? tile : CapabilityUtils.getBackpackInv(player);
        FluidTank leftTank = inv.getLeftTank();
        FluidTank rightTank = inv.getRightTank();
        int drops = 0;
        if (player != null && player.func_70090_H()) {
            drops += 2;
        }
        if (this.isUnderRain(tile == null ? player.func_233580_cy_() : tile.func_174877_v(), tile == null ? player.field_70170_p : tile.func_145831_w())) {
            ++drops;
        }
        FluidStack water = new FluidStack((Fluid)Fluids.field_204546_a, drops);
        if (!inv.getLevel().field_72995_K && inv.getLastTime() <= 0 && drops > 0) {
            inv.setLastTime(5);
            if (leftTank.isEmpty() || leftTank.getFluid().isFluidEqual(water)) {
                leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
            }
            if (rightTank.isEmpty() || rightTank.getFluid().isFluidEqual(water)) {
                rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
            }
            inv.setDataChanged(3);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            if (player.func_233643_dh_() && inv != null && inv.getItemStack().func_77973_b() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && inv.getAbilityValue() && inv.getLastTime() <= 0) {
                player.func_70606_j(1.0f);
                player.func_195061_cb();
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 450, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76426_n, 400, 0));
                player.field_70170_p.func_230546_a_((Entity)player, DamageSource.func_76365_a((PlayerEntity)player), null, player.func_226282_d_(0.5), player.func_226278_cu_(), player.func_226287_g_(0.5), 3.0f, false, Explosion.Mode.NONE);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187572_ar, SoundCategory.AMBIENT, 1.2f, 0.5f);
                if (!inv.getLevel().field_72995_K) {
                    inv.setLastTime((200 + 10 * player.field_70170_p.field_73012_v.nextInt(10)) * 50);
                    inv.setDataChanged(6);
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void dragonAbility(@Nullable PlayerEntity player) {
        this.magmaCubeAbility(player);
        this.squidAbility(player);
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, 210, 0, false, false, true));
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, 210, 0, false, false, true));
    }

    public void blazeAbility(@Nullable PlayerEntity player) {
        if (player.field_70143_R >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, player.func_226282_d_(0.5), player.func_226279_cv_(), player.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            player.field_70143_R = 0.0f;
        }
    }

    public void magmaCubeAbility(@Nullable PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76426_n, 210, 0, false, false, true));
    }

    public void witherAbility(@Nullable PlayerEntity player) {
        if (player.func_70660_b(Effects.field_82731_v) != null) {
            player.func_195063_d(Effects.field_82731_v);
        }
    }

    public void batAbility(@Nullable PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76439_r, 210, 0, false, false, true));
    }

    public void ocelotAbility(@Nullable PlayerEntity player) {
        if (player.field_70170_p.func_217360_a(MobEntity.class, OCELOT_ABILITY_PREDICATE, (LivingEntity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_174813_aQ().func_72314_b(6.0, 2.0, 6.0)) != null) {
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 20, 0, false, false, true));
        }
    }

    public void squidAbility(@Nullable PlayerEntity player) {
        if (player.func_70090_H()) {
            player.func_195064_c(new EffectInstance(Effects.field_76427_o, 210, 0, false, false, true));
            this.batAbility(player);
        }
    }

    private boolean isUnderRain(BlockPos pos, World world) {
        return world.func_226660_f_(pos) && world.func_72896_J();
    }

    public static boolean isOnList(Item[] list, ItemStack stackToCheck) {
        return Arrays.stream(list).anyMatch(s -> s == stackToCheck.func_77973_b());
    }
}

